*** Figure 4:  Change in Signatures on Discharge Petitions

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 

*** OPEN MAIN CD DTA 
use  "$data/main_CD.dta", clear

xtset cds year, delta(10)
egen stateyear=group(statefip year)

foreach t in 40 50 {
	
gen y_`t'=0
replace y_`t'=1 if year==19`t'

gen fr_b40n_p78_y`t'=fr_b40n_p78*y_`t'
gen dem_40_y`t'=dem_40*y_`t'
gen wp_civilrightsagn_78_y`t'=wp_civilrightsagn_78*y_`t'
gen wp_civilrightscons_78_y`t'=wp_civilrightscons_78*y_`t'

}
.


keep if year==1940



* regressions
cd  "$output"
 

* Baseline
 
* 2SLS 

foreach i in D_combined EPL_D_81_78 AL_D_80_77  PT_D_79_77 {

rename D_fr_bl_p78 `i'_black

ivreg2 `i'   (`i'_black=Z_p78)    ///
fr_b40n_p78  dem_40  wp_civilrightsagn_78  i.statefip ///
[aw=pop_cd78], cl(cds) ffirst

estimates store `i'_black
rename `i'_black D_fr_bl_p78

}

coefplot ///
(D_combined_black EPL_D_81_78_black AL_D_80_77_black PT_D_79_77_black),vertical  yline(0, lcolo(black)) ciopts(recast(rcap) lcolor(maroon)) citop  /// 
keep (D_combined_black EPL_D_81_78_black AL_D_80_77_black  PT_D_79_77_black) ///
coeflabels( ///
D_combined_black= "All"  ///
EPL_D_81_78_black="FEPC" ///
AL_D_80_77_black="Anti-Lynching" ///
PT_D_79_77_black="Poll Tax", wrap(17)) ///
legend(off) ytitle("2SLS Coefficient on change in Black share") graphregion(fcolor(white) ilcolor(white) lcolor(white)) ylabel (0(0.5)2,nogrid) xla(, notick) 
 
graph export "Figure4.eps", replace
